//
//  MCMailerSettings.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 11/08/09.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


extern NSString*  kMCMailerSettingsServerAddressKey; // NSString
extern NSString*  kMCMailerSettingsServerPortKey;  // NSNumber - unsigned short
extern NSString*  kMCMailerSettingsUseTLSKey; // NSNumber - BOOL
extern NSString*  kMCMailerSettingsUsePasswordAuthenticationKey; // NSNumber - BOOL
extern NSString*  kMCMailerSettingsAuthUsernameKey; // NSString
extern NSString*  kMCMailerSettingsAuthPasswordKey; // NSString
extern NSString*  kMCMailerSettingsAdminEmailAddressKey; // NSString


@interface MCMailerSettings : NSObject {
    NSMutableDictionary*   mailerSettings;
}

+ (MCMailerSettings*)mailerSettingsFromPListAtPath: (NSString*)plistPath;


- (id)initWithSettingsFromPListAtPath: (NSString*)plistPath;

- (BOOL)saveSettingsToPListAtPath: (NSString*)plistPath error: (NSError**)error;

- (NSString *)mailServerAddress;
- (void)setMailServerAddress:(NSString *)aMailServerAddress;
- (UInt16)mailServerPort;
- (void)setMailServerPort:(UInt16)aMailServerPort;

- (BOOL)useTLS;
- (void)setUseTLS:(BOOL)flag;

- (BOOL)usePasswordAuthentication;
- (void)setUsePasswordAuthentication: (BOOL)flag;

- (NSString *)username;
- (void)setUsername:(NSString *)anUsername;
- (NSString *)password;
- (void)setPassword:(NSString *)aPassword;

- (NSString *)adminEmailAddress;
- (void)setAdminEmailAddress:(NSString *)anAdminEmail;

- (NSMutableDictionary *)mailerSettings;

@end
